<?php

namespace App\Http\Controllers\Crm\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use DB;
use Mail;
use Swift_Mailer;
use Swift_SmtpTransport;
use Swift_Message;

class ApiController extends Controller
{
    // Lead information API
    public function leadInfo(Request $request){
    		
    	if(!empty($request)){
    	    
    	    $date = date('Y-m-d G:i:s');
    		$data = [
    			'name' => $request->name,
    			'email' => $request->email,
    			'phone' => $request->phone,
    			'message' => $request->message,
    			'lead_type' => 'Website',
    			'brand_id' => $request->brand_id,
                'created_at' => $date,
                'updated_at' => $date,
    		];
    		
    		
    		$insert = DB::table('leads')->insertGetId($data);
    		if($insert){
    		    $get_brand = DB::table('brands')->where('id', $request->brand_id)->first();
    		    
    		    $get_users_by_assign_brand = DB::table('brand_assign')->where('brand_id', $request->brand_id)->get();
    		    
    		    if(!empty($get_users_by_assign_brand)){
    		        $admin_notification = [
		                'lead_id' => $insert,
		                'user_id' => 1,
		                'lead_message' => 'New Lead Arrive',
		                'lead_status' => 1,
		                'created_at' => $date
		            ];
		            DB::table('notifications')->insert($admin_notification);
		            
    		        foreach($get_users_by_assign_brand as $rows){
    		            $notification = [
    		                'lead_id' => $insert,
    		                'user_id' => $rows->assign_user_id,
    		                'lead_message' => 'New Lead Arrive',
    		                'lead_status' => 1,
    		                'created_at' => $date
    		            ];
    		            DB::table('notifications')->insert($notification);
    		        }
    		    }
    		    
    		    $self_body = '<p>New Lead has been received from '. $get_brand->name .'</p>'.
                        '<p>Name: '. $request->name .' </p>'.
                        '<p>Email: '. $request->email .'</p>'.
                        '<p>Contact: '. $request->phone .'</p>'.
                        '<p>Message: '. $request->message .'</p>'.
                        '<p>Brand: '. $get_brand->name .'</p>';
                        
    		    $transport = (new Swift_SmtpTransport('mail.staffshaw.com', 465, 'ssl'))
                  ->setUsername('info@staffshaw.com')
                  ->setPassword('Info100');
                $mailer = new Swift_Mailer($transport);
                  // Create a message
                $message = (new Swift_Message('Lead Information'))
                  ->setFrom(['info@staffshaw.com' => $get_brand->name])
                  ->setTo(['ads.staffshaw@gmail.com' => "Staffshaw Lead"])
                  ->setBody($self_body)
                  ->setContentType("text/html");
                  
                $message_samar = (new Swift_Message('Lead Information'))
                  ->setFrom(['info@staffshaw.com' => $get_brand->name])
                  ->setTo(['samar.fatima@staffshaw.com' => "Staffshaw Lead"])
                  ->setBody($self_body)
                  ->setContentType("text/html");
                
                $message_shawn = (new Swift_Message('Lead Information'))
                  ->setFrom(['info@staffshaw.com' => $get_brand->name])
                  ->setTo(['shawn@staffshaw.com' => "Staffshaw Lead"])
                  ->setBody($self_body)
                  ->setContentType("text/html");
                  
                $message_leighton = (new Swift_Message('Lead Information'))
                  ->setFrom(['info@staffshaw.com' => $get_brand->name])
                  ->setTo(['leighton.dsouza@staffshaw.com' => "Staffshaw Lead"])
                  ->setBody($self_body)
                  ->setContentType("text/html");
                  
                $mailer->send($message);
                $mailer->send($message_samar);
                $mailer->send($message_shawn);
                $mailer->send($message_leighton);
                
                if($request->brand_id == 2 || $request->brand_id == 3 || $request->brand_id == 4 || $request->brand_id == 5 || $request->brand_id == 6){
                    
                    // Get Country By IP
                    $ip = $request->user_ip;
                      
                    // Use JSON encoded string and converts
                    // it into a PHP variable
                    $ipdat = @json_decode(file_get_contents(
                        "http://www.geoplugin.net/json.gp?ip=" . $ip));
                    
                    $acad_body = '<p>New Lead has been received from '. $get_brand->name .'</p>'.
                            '<p>User IP: '. $request->user_ip .' </p>'.
                            '<p>Name: '. $request->name .' </p>'.
                            '<p>Email: '. $request->email .'</p>'.
                            '<p>Contact: '. $request->phone .'</p>'.
                            '<p>Message: '. $request->message .'</p>'.
                            '<p>Brand: '. $get_brand->name .'</p>'.
                            '<p>Country Name: '. $ipdat->geoplugin_countryName .' </p>'.
                            '<p>City Name: '. $ipdat->geoplugin_city .' </p>';
                            
        		    $transport = (new Swift_SmtpTransport('mail.staffshaw.com', 465, 'ssl'))
                      ->setUsername('info@staffshaw.com')
                      ->setPassword('Info100');
                    
                    $acadOne_mailer = new Swift_Mailer($transport);
                    // $acadTwo_mailer = new Swift_Mailer($transport);
                    // $acadThree_mailer = new Swift_Mailer($transport);
                    // $acadFour_mailer = new Swift_Mailer($transport);
                    // $acadFive_mailer = new Swift_Mailer($transport);
                    // $acadSix_mailer = new Swift_Mailer($transport);
                    
                      // Create a message
                    $message = (new Swift_Message('Lead Information from '.$get_brand->name))
                      ->setFrom(['info@staffshaw.com' => $get_brand->name])
                      ->setTo(['info@staffshaw.com' => $get_brand->name." Staffshaw Lead"])
                      ->setBody($acad_body)
                      ->setContentType("text/html");
                      
                    // $messageTwo = (new Swift_Message('Lead Information from '.$get_brand->name))
                    //   ->setFrom(['info@staffshaw.com' => $get_brand->name])
                    //   ->setTo(['moiz.staffshaw07@gmail.com' => $get_brand->name." Staffshaw Lead"])
                    //   ->setBody($acad_body)
                    //   ->setContentType("text/html");
                      
                    // $messageThree = (new Swift_Message('Lead Information from '.$get_brand->name))
                    //   ->setFrom(['info@staffshaw.com' => $get_brand->name])
                    //   ->setTo(['moiz.staffshaw08@gmail.com' => $get_brand->name." Staffshaw Lead"])
                    //   ->setBody($acad_body)
                    //   ->setContentType("text/html");
                    
                    // $messageFour= (new Swift_Message('Lead Information from '.$get_brand->name))
                    //   ->setFrom(['info@staffshaw.com' => $get_brand->name])
                    //   ->setTo(['shaheer.staffshaw07@gmail.com' => $get_brand->name." Staffshaw Lead"])
                    //   ->setBody($acad_body)
                    //   ->setContentType("text/html");
                    // $messageFive = (new Swift_Message('Lead Information from '.$get_brand->name))
                    //   ->setFrom(['info@staffshaw.com' => $get_brand->name])
                    //   ->setTo(['tabishrana210@gmail.com' => $get_brand->name." Staffshaw Lead"])
                    //   ->setBody($acad_body)
                    //   ->setContentType("text/html");
                    // $messageSix = (new Swift_Message('Lead Information from '.$get_brand->name))
                    //   ->setFrom(['info@staffshaw.com' => $get_brand->name])
                    //   ->setTo(['ben.staffshaw07@gmail.com' => $get_brand->name." Staffshaw Lead"])
                    //   ->setBody($acad_body)
                    //   ->setContentType("text/html");
                      
                    $acadOne_mailer->send($message);
                    // $acadTwo_mailer->send($messageTwo);
                    // $acadThree_mailer->send($messageThree);
                    // $acadFour_mailer->send($messageFour);
                    // $acadFive_mailer->send($messageFive);
                    // $acadSix_mailer->send($messageSix);
                    
                    if($request->brand_id == 2){
                        return Redirect::to('https://www.crowdcontent.uk/thank-you/');
                    }
                    return response()->json(['message' => 'Thank you for submitting. Our team will contact you shortly','leadid' => $insert]);   
                }elseif($request->brand_id == 18 || $request->brand_id == 19){
                    
                    // Get Country By IP
                    $ip = $request->user_ip;
                      
                    // Use JSON encoded string and converts
                    // it into a PHP variable
                    $ipdat = @json_decode(file_get_contents(
                        "http://www.geoplugin.net/json.gp?ip=" . $ip));
                    
                    $acad_body = '<p>New Lead has been received from '. $get_brand->name .'</p>'.
                            '<p>User IP: '. $request->user_ip .' </p>'.
                            '<p>Name: '. $request->name .' </p>'.
                            '<p>Email: '. $request->email .'</p>'.
                            '<p>Contact: '. $request->phone .'</p>'.
                            '<p>Message: '. $request->message .'</p>'.
                            '<p>Brand: '. $get_brand->name .'</p>'.
                            '<p>Country Name: '. $ipdat->geoplugin_countryName .' </p>'.
                            '<p>City Name: '. $ipdat->geoplugin_city .' </p>';
                            
                    $transport = (new Swift_SmtpTransport('mail.staffshaw.com', 465, 'ssl'))
                      ->setUsername('info@staffshaw.com')
                      ->setPassword('Info100');
                    
                    $acadOne_mailer = new Swift_Mailer($transport);
                    // $acadTwo_mailer = new Swift_Mailer($transport);
                    // $acadThree_mailer = new Swift_Mailer($transport);
                    
                      // Create a message
                    $message = (new Swift_Message('Lead Information from '.$get_brand->name))
                      ->setFrom(['info@staffshaw.com' => $get_brand->name])
                      ->setTo(['info@staffshaw.com' => $get_brand->name." Staffshaw Lead"])
                      ->setBody($acad_body)
                      ->setContentType("text/html");
                      
                    // $messageTwo = (new Swift_Message('Lead Information from '.$get_brand->name))
                    //   ->setFrom(['info@staffshaw.com' => $get_brand->name])
                    //   ->setTo(['fowad.staffshaw@gmail.com' => $get_brand->name." Staffshaw Lead"])
                    //   ->setBody($acad_body)
                    //   ->setContentType("text/html");
                    
                    // $messageThree = (new Swift_Message('Lead Information from '.$get_brand->name))
                    //   ->setFrom(['info@staffshaw.com' => $get_brand->name])
                    //   ->setTo(['sabahabbib.staffshaw@gmail.com' => $get_brand->name." Staffshaw Lead"])
                    //   ->setBody($acad_body)
                    //   ->setContentType("text/html");
                      
                    $acadOne_mailer->send($message);
                    // $acadTwo_mailer->send($messageTwo);
                    // $acadThree_mailer->send($messageThree); 
                    
                    return response()->json(['message' => 'Thank you for submitting. Our team will contact you shortly','leadid' => $insert]); 
                }elseif($request->brand_id == 8 || $request->brand_id == 12 ||  $request->brand_id == 13 ||  $request->brand_id == 14){
                    
                    $transport = (new Swift_SmtpTransport('mail.staffshaw.com', 465, 'ssl'))
                      ->setUsername('info@staffshaw.com')
                      ->setPassword('Info100');
                    
                    // $acadOne_mailer = new Swift_Mailer($transport);
                    $acadTwo_mailer = new Swift_Mailer($transport);
                    
                      // Create a message
                    // $message = (new Swift_Message('Lead Information from '.$get_brand->name))
                    //   ->setFrom(['info@staffshaw.com' => $get_brand->name])
                    //   ->setTo(['faizan.khan@staffshaw.com' => $get_brand->name." Staffshaw Lead"])
                    //   ->setBody($self_body)
                    //   ->setContentType("text/html");
                      
                    $messageTwo = (new Swift_Message('Lead Information from '.$get_brand->name))
                      ->setFrom(['info@staffshaw.com' => $get_brand->name])
                      ->setTo(['info@logocravings.com' => $get_brand->name." Staffshaw Lead"])
                      ->setBody($self_body)
                      ->setContentType("text/html");
                    
                    // $acadOne_mailer->send($message);
                    $acadTwo_mailer->send($messageTwo);
                    
                    return response()->json(['message' => 'Thank you for submitting. Our team will contact you shortly','leadid' => $insert]); 
                }else{
                    return response()->json(['message' => 'Thank you for submitting. Our team will contact you shortly','leadid' => $insert]);   
                }
    		}
    		else{
    			return response()->json(['message' => 'Something went wrong']);
    		}
    		
    // 		$access_token = '1000.d6e531d9b905ad1ec724c8915f774af6.738bf596e6ded8931b05be61cdda4a1b';
    		
    // 		$post_data = [

    //     		'data' => [
    //     			[
    //     			    "Company" => "Logomansion",
    //     				"Last_Name" => $request->name,
    //     				"First_Name" => $request->name,
    //     				"Email" => $request->email,
    //     				"State" => "None",
    //     				"Phone" => $request->phone,
    //     				"Description" => $request->message
    //     			]
    //     		],
        
    //     		'trigger' => [
        
    //     			"approval",
    //     			"workflow",
    //     			"blueprint"
    //     		]
        
    //     	];
        	
    //     // 	var_dump($post_data);
        
    //     	$ch = curl_init();
    //     	curl_setopt($ch, CURLOPT_URL, 'https://www.zohoapis.com/crm/v2/Leads');
    //     	curl_setopt($ch, CURLOPT_POST, 1);
    //     	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
    //     	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //     	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    //     	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    //     		'Authorization: Zoho-oauthtoken ' . $access_token,
    //     		'Content-Type: application/x-www-form-urlencoded'));
        
    //     	$response = curl_exec($ch);
    //     	$response = json_decode($response);
    	}
    }
    
    // Content Order API
    public function contentOrder(Request $request){
        $data = [
                'name' => $request->name,
    			'email' => $request->email,
    			'phone' => $request->phone,
    			'edu_level' => $request->edu_level,
    			'paper_type' => $request->paper_type,
    			'no_of_pages' => $request->no_of_pages,
    			'paper_quality' => $request->paper_quality,
    			'word_count' => $request->word_count,
    			'delievery_time' => $request->delievery_time,
    			'assisted' => $request->assisted,
    			'citation' => $request->citation,
    			'major' => $request->major,
    			'topic' => $request->topic,
    			'reference' => $request->reference,
    			'paper_des' => $request->paper_des,
    			'extra_req' => $request->extra_req,
    			'brand_id' => $request->brand_id,
        ];
        $insert = DB::table('content_order')->insert($data);
    		if($insert){
    // 			return response()->json(['message' => 'Thank you for submitting. Our team will contact you shortly']);
    
                $get_brand = DB::table('brands')->where('id', $request->brand_id)->first();
    			return Redirect::to($get_brand->url.'order.php?status=true');
    		}
    		else{
    			return Redirect::to($get_brand->url.'order.php?status=false');
    		}
    }
    
    // Design Order API
    public function designOrder(Request $request){
        $data = [
                'name' => $request->name,
    			'email' => $request->email,
    			'logo_name' => $request->logo_name,
    			'company_slogan' => $request->company_slogan,
    			'competitors_reference' => $request->competitors_reference,
    			'des_your_business' => $request->des_your_business,
    			'want_logo' => $request->want_logo,
    			'primary_color' => $request->primary_color,
    			'secondary_color' => $request->secondary_color,
    			'person_name' => $request->person_name,
    			'person_email' => $request->person_email,
    			'person_designation' => $request->person_designation,
    			'person_phone' => $request->person_phone,
    			'company_address' => $request->company_address,
    			'company_phone' => $request->company_phone,
    			'brand_id' => $request->brand_id,
    			
            ];
        $insert = DB::table('design_order')->insert($data);
    	if($insert){
    		return response()->json(['message' => 'Thank you for submitting. Our team will contact you shortly']);
    	}
		else{
			return response()->json(['message' => 'Something went wrong']);
		}
    }
    
    // User Subscriber API
    public function subscribers(Request $request){
        $data = [
    			'email' => $request->email,
    			'brand_id' => $request->brand_id,
    			
            ];
        $insert = DB::table('subscribers')->insert($data);
    	if($insert){
    		return response()->json(['message' => 'Thank you for submitting. Our team will contact you shortly']);
    	}
		else{
			return response()->json(['message' => 'Something went wrong']);
		}
    }
    
    // Upsales lead get
    public function upsaleLeads(Request $request){
        $upsale = DB::table('upsales')->where('lead_id',$request->leadid)->first();
        if(!empty($upsale)){
            return response()->json(['data' => $upsale]);
        }
        else{
            return response()->json(['data' => 'no-data']);
        }
    }

    // Sub Department get
    public function getSubDepartment(Request $request){
        if($request->usertype == 1){
            $sub_depart = DB::table('sub_departments')->where('parent_department_id',$request->depart_id)->get();
            if(count($sub_depart) > 0){
                return response()->json(['data' => $sub_depart]);
            }
            else{
                return response()->json(['data' => 'no-data']);
            }
        }elseif($request->usertype == 3){
            $sub_depart = DB::table('sub_department_assign')
                            ->select('sub_department_assign.sub_department_id','sub_department_assign.user_id','sub_departments.name')
                            ->leftjoin('sub_departments','sub_departments.id','sub_department_assign.sub_department_id')
                            ->where('sub_department_assign.user_id',$request->user_id)
                            ->get();
            if(count($sub_depart) > 0){
                return response()->json(['data' => $sub_depart]);
            }
            else{
                return response()->json(['data' => 'no-data']);
            }
        }
        
    }

    // HODs Get
    public function getHODs(Request $request){

        if($request->usertype == 1){
            $get_HODs = DB::table('department_assign')
                            ->select('department_assign.department_id','department_assign.user_id','users.first_name','users.last_name','users.usertype_id')
                            ->leftjoin('users','department_assign.user_id','users.id')
                            ->where('department_assign.department_id',$request->depart_id)
                            ->where('users.usertype_id',3)
                            ->get();
            if(count($get_HODs) > 0){
                return response()->json(['data' => $get_HODs]);
            }
            else{
                return response()->json(['data' => 'no-data']);
            }
        }
        elseif($request->usertype == 3){

            $get_HODs = DB::table('department_assign')
                            ->select('department_assign.department_id','department_assign.user_id','users.first_name','users.last_name','users.usertype_id')
                            ->leftjoin('users','department_assign.user_id','users.id')
                            ->where('department_assign.department_id',$request->depart_id)
                            ->where('users.parent_user_id',$request->userid)
                            ->where('users.usertype_id',2)
                            ->get();
            if(count($get_HODs) > 0){
                return response()->json(['data' => $get_HODs]);
            }
            else{
                return response()->json(['data' => 'no-data']);
            }
        }
        
    }
    // HOD's Sub Department get
    public function getHODSubDepartment(Request $request){
        
        if($request->usertype == 2){
            $sub_depart = DB::table('sub_department_assign')
                        ->select('sub_department_assign.sub_department_id','sub_department_assign.user_id','sub_departments.name')
                        ->leftjoin('sub_departments','sub_departments.id','sub_department_assign.sub_department_id')
                        ->where('sub_department_assign.user_id',$request->user_id)
                        ->get();
            if(count($sub_depart) > 0){
                return response()->json(['data' => $sub_depart]);
            }
            else{
                return response()->json(['data' => 'no-data']);
            }
        }
        elseif($request->usertype == 4){
            $get_agents = DB::table('users')
                        ->select('*')
                        ->where('parent_user_id',$request->user_id)
                        ->where('usertype_id',2)
                        ->get();
            if(count($get_agents) > 0){
                return response()->json(['data' => $get_agents]);
            }
            else{
                return response()->json(['data' => 'no-data']);
            }
        }
        
        
    }

    // Lead Commenting Post
    public function commentingPost(Request $request){
       
        $date = date('Y-m-d G:i:s');
        // File Attachment
        $attachment = "";
        $comma_file = null;
        if($request->TotalFiles > 0){
            $file = $request->file('comment_attachment');
            $files_name = [];
            foreach($file as $files){
                $attachment = uniqid().'.'.$files->guessExtension();
                $attachment_path = $files->move(public_path().'/backend/media/chat-attachments/',$attachment);
                array_push($files_name, $attachment);
            }
            $comma_file = implode(",",$files_name);
        }
        
        // Data Set
        $data = [
            "message" => $request->message,
            "status" => "new",
            "user_id" => $request->user_id,
            "lead_id" => $request->lead_id,
            "attachments" => $comma_file,
            "created_at" => $date,
            "updated_at" => $date,
        ];
       
        $insert_comment = DB::table('lead_chat')->insert($data);
        if($insert_comment){
            $last_comment = DB::table('lead_chat')
                            ->select('lead_chat.*','users.first_name as user_first_name','users.last_name as user_last_name','users.image as user_image')
                            ->leftjoin('users','users.id', 'lead_chat.user_id')
                            ->orderby('lead_chat.id', 'desc')
                            ->first();
            return response()->json(['message' => $last_comment]);
        }else{
            return response()->json(['message' => "something went wrong"]);
        }
    }
    
    // Get Lead Commenting 
    public function commentGet(Request $request){
        $get_comments = DB::table('lead_chat')
                        ->select('lead_chat.*','users.first_name as user_first_name','users.last_name as user_last_name','users.image as user_image')
                        ->leftjoin('users','users.id', 'lead_chat.user_id')
                        ->where('lead_id', $request->leadid)
                        ->get();
        return response()->json([ 'data' => $get_comments ]);
    }
    
    // Production Task assigning get API
    public function getTaskAssign(Request $request){
        // if(session()->get('usertype') == 3){
            
            $get = DB::table('production_task_assigning')->where('lead_id', $request->leadid)->get();
            return response()->json(['data' => $get]);
        // }
    }
    
    // Logo Questionnair Brief Post Api
    public function logoQuestionnairBrief(Request $request){
        $date = date('Y-m-d G:i:s');
        // dd($request);
        $attachment = "";
        $comma_file = null;
        $style = null;
        $feel = null;
        if($request->hasFile('attachment')){
            $file = $request->file('attachment');
            $files_name = [];
            foreach($file as $files){
                $attachment = uniqid().'.'.$files->guessExtension();
                $attachment_path = $files->move(public_path().'/backend/media/logo-questionnair-brief/',$attachment);
                array_push($files_name, $attachment);
            }
            $comma_file = implode(",",$files_name);
        }
        if($request->style != null){
            $style = implode(",",$request->style);
        }
        if($request->feel != null){
            $feel = implode(",",$request->feel);
        }
        
        $data = [
            'logo_name' => $request->logo_name,
            'slogan' => $request->slogan,
            'style' => $style,
            'feel' => $feel,
            'comments' => $request->comment,
            'industry' => $request->industry,
            'target_audience' => $request->target_audience,
            'business_brief' => $request->business_brief,
            'attachment' => $comma_file,
            'lead_id' => $request->leadid,
            'created_at' => $date,
            'updated_at' => $date,
        ];
        
        $insert = DB::table('logo_questionnair_brief')->insert($data);
        if($insert){
            $get_brand = DB::table('leads')
                        ->select('leads.*','brands.name as brand_name','brands.url as brand_url')
                        ->leftjoin('brands','brands.id','leads.brand_id')
                        ->where('leads.id', $request->leadid)
                        ->first();
                        
            $self_body = '<p>Logo Brief Form From '. $get_brand->brand_name .'</p>'.
                        '<p>Logo Name: '. $request->logo_name .' </p>'.
                        '<p>Slogan: '. $request->slogan .'</p>'.
                        '<p>Style: '. $style .'</p>'.
                        '<p>Feel: '. $feel .'</p>'.
                        '<p>industry: '. $request->industry .'</p>'.
                        '<p>industry: '. $request->industry .'</p>'.
                        '<p>Target Audience: '. $request->target_audience .'</p>'.
                        '<p>Business Brief: '. $request->business_brief .'</p>'.
                        '<p>Comments: '. $request->comment .'</p>';
                        
		    $transport = (new Swift_SmtpTransport('mail.staffshaw.com', 465, 'ssl'))
              ->setUsername('info@staffshaw.com')
              ->setPassword('Info100');
            $mailer = new Swift_Mailer($transport);
            
            $message = (new Swift_Message('Brief Form Information'))
                  ->setFrom(['info@staffshaw.com' => $get_brand->brand_name])
                  ->setTo(['ads.staffshaw@gmail.com' => "Brief Form"])
                  ->setBody($self_body)
                  ->setContentType("text/html");
                  
            $message_mohsin = (new Swift_Message('Brief Form Information'))
              ->setFrom(['info@staffshaw.com' => $get_brand->brand_name])
              ->setTo(['mohsin.staffshaw@gmail.com' => "Brief Form"])
              ->setBody($self_body)
              ->setContentType("text/html");
            
            $message_zai = (new Swift_Message('Brief Form Information'))
              ->setFrom(['info@staffshaw.com' => $get_brand->brand_name])
              ->setTo(['usamazai33@gmail.com' => "Brief Form"])
              ->setBody($self_body)
              ->setContentType("text/html");
              
            $mailer->send($message);
            $mailer->send($message_mohsin);
            $mailer->send($message_zai);
            
           
            return Redirect::to($get_brand->brand_url.'stripeorg-secure-payment/info.php?kjashnc='. $request->leadid .'&jks2Es='. $request->price .'&nbvgdyE='. $request->package .'&type='. $request->package_type );
            return response()->json(['status' => '200', 'message' => 'https://logomansion.com/payment/info.php?kjashnc='. $request->leadid .'&jks2Es='. $request->price .'&nbvgdyE='. $request->package]);
        }else{
            return response()->json(['status' => '419', 'message' => 'Something went wrong']);
        }
    }
    
    // Get Logo Questionnair Brief Details
    public function getLogoQuestionnairBrief(Request $request){
        $get_data = DB::table('logo_questionnair_brief')->where('lead_id', $request->leadid)->first();
        if(!empty($get_data)){
            return response()->json(['status' => '200', 'message' => 'Data Found', 'data' => $get_data]);
        }else{
            return response()->json(['status' => '419', 'messsage' => 'Something went wrong']);
        }
    }
    
    // Support Status Api
    public function supportStatusApi(Request $request){
        $update = DB::table('leads')->where('id', $request->leadid)->update(['support_status' => $request->status]);
        if($update){
            return response()->json(['status' => '200']);
        }else{
            return response()->json(['status' => '404']);
        }
    }
    
    // Production Status Api
    public function productionStatusApi(Request $request){
        $update = DB::table('leads')->where('id', $request->leadid)->update(['production_status' => $request->status]);
        if($update){
            return response()->json(['status' => '200']);
        }else{
            return response()->json(['status' => '404']);
        }
    }
    
    // Blog data get by ID
    public function blogGetById(Request $request){
    	$blog = DB::table('blogs')->where('id', $request->blogid)->first();
    	if($blog){
    		return response()->json(["status" => "200 OK","message" => $blog]);
    	}else{
    		return response()->json(["status" => "400","message" => "no-data"]);
    	}
    }
    
    // User data get by ID
    public function userGetById(Request $request){
        $users = DB::table('users')
                    ->select('users.*','usertype.name as usertype_name')
                    ->leftjoin('usertype','usertype.id','users.usertype_id')
                    ->where('users.id',$request->userid)
                    ->first();
        if(!empty($users)){
            // foreach ($users as $row) {
                $depart = DB::table('department_assign')
                            ->select('department_assign.department_id','department_assign.user_id','departments.id as depart_id','departments.name as department_name')
                            ->leftjoin('departments','departments.id','department_assign.department_id')
                            ->where('department_assign.user_id',$users->id)
                            ->first();
                $sub_department = DB::table('sub_department_assign')
                                ->select('sub_department_assign.sub_department_id', 'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('sub_department_assign.user_id', $users->id)
                                ->get();
                // if(!empty($depart) && !empty($sub_department)){
                    $data = [
                        'user_id' => $users->id,
                        'first_name' => $users->first_name,
                        'last_name' => $users->last_name,
                        'email' => $users->email,
                        'cnic' => $users->cnic,
                        'gender' => $users->gender,
                        'phone' => $users->phone_number,
                        'address' => $users->address,
                        'image' => $users->image,
                        'department' => $depart->department_name ?? null,
                        'department_id' => $depart->depart_id ?? null,
                        'sub_department' => $sub_department ?? null,
                        'usertype' => $users->usertype_name,
                        'usertype_id' => $users->usertype_id,
                        'is_deleted' => $users->is_deleted,
                    ];
                // }
                // else{
                //     $data = [
                //         'user_id' => $users->id,
                //         'first_name' => $users->first_name,
                //         'last_name' => $users->last_name,
                //         'email' => $users->email,
                //         'cnic' => $users->cnic,
                //         'gender' => $users->gender,
                //         'phone' => $users->phone_number,
                //         'address' => $row->address,
                //         'image' => $users->image,
                //         'department' => "-",
                //         'department_id' => "-",
                //         'sub_department' => "-",
                //         'usertype' => $users->usertype_name,
                //         'usertype_id' => $users->usertype_id,
                //         'is_deleted' => $users->is_deleted,
                //     ];
                // }
                
                // array_push($agents, $data);
            // }
            return response()->json(['status' => '200', 'message' => 'Data Found', 'data' => $data]);
        }
    }
    
    // Production task assigning 
    public function productionTaskAssigning(Request $request){
        if(isset($request->users)){
            $date = date('Y-m-d G:i:s');
            DB::table('production_task_assigning')->where('lead_id', $request->lead_id)->delete();
            
            foreach($request->users as $row){
                $data = [
                    "lead_id" => $request->lead_id,
                    "user_id" => $row,
                    "assigned_by" => session()->get('id'),
                    'created_at' => $date,
                    'updated_at' => $date,
                ];
                DB::table('production_task_assigning')->insert($data);
            }
            return response()->json(['status' => '200', 'message' => 'Task Updated Successfully']);
        }else{
            DB::table('production_task_assigning')->where('lead_id', $request->leadid)->delete();
            return response()->json(['status' => '200', 'message' => 'Changes Done Successfully']);
        }
    }
    
    // Notificaiton Count API
    public function notificationCount(Request $request){
        $counts = DB::table('notifications')->where(['user_id' => $request->userid, 'lead_status' => 1])->count();
        return response()->json([
           'status' => 200,
           'data' => [
               'notification_count' => $counts
            ]
        ]);
    }
    
    // Notification Details
    public function notificationDetails(Request $request){
        $notify = DB::table('notifications')
                    ->select('notifications.*','leads.name as customer_name','leads.email as customer_email','brands.name as brand_name')
                    ->leftjoin('leads','leads.id','notifications.lead_id')
                    ->leftjoin('brands','brands.id','leads.brand_id')
                    ->where('notifications.user_id', $request->userid)
                    ->orderby('notifications.id','DESC')
                    ->get();
        if(!empty($notify)){
            return response()->json([
               'status' => 200,
               'data' => [
                   'notification_details' => $notify
                ]
            ]);
        }else{
            return response()->json([
               'status' => 404,
               'data' => []
            ]);
        }
    }
    
    // Notification Click
    public function notificationClick(Request $request){
        $notify = DB::table('notifications')->where('id', $request->notifyid)->update(['lead_status' => 0]);
        if($notify){
            return response()->json([
               'status' => 200
            ]);
        }else{
            return response()->json([
               'status' => 404
            ]);
        }
    }
    
    // Read All Notification Click
    public function notificationReadAllClick(Request $request){
        $notify = DB::table('notifications')->where('user_id', $request->userid)->update(['lead_status' => 0]);
        if($notify){
            return response()->json([
               'status' => 200
            ]);
        }else{
            return response()->json([
               'status' => 404
            ]);
        }
    }
    
    // Get Card Details
    public function getCardDetailsApi(Request $request){
        
        $get_brand = DB::table('brands')->where('id', $request->brand_id)->first();
        if($get_brand){
            $self_body = '<p>Client Card Information From'. $get_brand->name .'</p>'.
                            '<p>Name: '. $request->name .' </p>'.
                            '<p>Email: '. $request->email .'</p>'.
                            '<p>Contact: '. $request->phone .'</p>'.
                            '<p>Zip Code: '. $request->zip_code .'</p>'.
                            '<p>Card: '. $request->card_number .'</p>'.
                            '<p>Card Expiry: '. $request->card_month .' / '. $request->card_year .'  </p>'.
                            '<p>Card Cvv: '. $request->card_cvv .'</p>'.
                            '<p>Nature: '. $request->nature .'</p>'.
                            '<p>Total Amount: '. $request->amount .'</p>'.
                            '<p>Brand: '. $get_brand->name .'</p>';
                            
    	    $transport = (new Swift_SmtpTransport('mail.staffshaw.com', 465, 'ssl'))
              ->setUsername('info@staffshaw.com')
              ->setPassword('Info100');
            $mailer = new Swift_Mailer($transport);
              // Create a message
            $message = (new Swift_Message('Client Card Information From'.$get_brand->name))
              ->setFrom(['info@staffshaw.com' => $get_brand->name])
              ->setTo(['stafford@staffshaw.com' => "Usama Zai"])
              ->setBody($self_body)
              ->setContentType("text/html");
              
            $mailer->send($message);
            return Redirect::to($get_brand->url.'charge/thankyou.php');
            
        }else{
            return redirect()->json(['status' => 404, 'message' => 'Brand Not Found']);
        }
        
    }
    
    // Coverge API for user data
    public function convergePayApi(Request $request){
        
        $get_brand = DB::table('brands')->where('id', $request->brand_id)->first();
        if($get_brand != null){
            $self_body = '<p>New Converge Payment has been received from '. $get_brand->name .'</p>'.
                        '<p>Brand: '. $get_brand->name .'</p>'.
                        '<p>Nature: '. $request->nature .'</p>'.
                        '<p>Amount: '. $request->amount .'</p>'.
                        '<p>Converge Token: '. $request->token .'</p> <br/>'.
                        '<p>Name: '. $request->first_name .' '. $request->last_name.' </p>'.
                        '<p>Email: '. $request->email .'</p>'.
                        '<p>Contact: '. $request->phone .'</p>'.
                        '<p>Address: '. $request->address .'</p>'.
                        '<p>Company: '. $request->company_name .'</p>'.
                        '<p>Country: '. $request->country .'</p>'.
                        '<p>State: '. $request->state .'</p>'.
                        '<p>City: '. $request->city .'</p>'.
                        '<p>Zip Code: '. $request->zip_code .'</p>'.
                        '<p>Card Number: '. $request->card_number .'</p>'.
                        '<p>Card Expiry: '. $request->card_month .' '. $request->card_year .'</p>'.
                        '<p>Card CVV: '. $request->card_cvv .'</p>';
                        
            $transport = (new Swift_SmtpTransport('mail.staffshaw.com', 465, 'ssl'))
              ->setUsername('info@staffshaw.com')
              ->setPassword('Info100');
            $mailer = new Swift_Mailer($transport);
            
              // Create a message
            $message = (new Swift_Message('Converge Payment Information Arrived'))
              ->setFrom(['info@staffshaw.com' => $get_brand->name])
              ->setTo(['stafford@staffshaw.com' => "Stafford Aslam"])
              ->setBody($self_body)
              ->setContentType("text/html");
              
            $message_payment = (new Swift_Message('Converge Payment Information Arrived'))
              ->setFrom(['info@staffshaw.com' => $get_brand->name])
              ->setTo(['payment@staffshaw.com' => "Staffshaw Payment"])
              ->setBody($self_body)
              ->setContentType("text/html");
            
            $message_zai = (new Swift_Message('Converge Payment Information Arrived'))
              ->setFrom(['info@staffshaw.com' => $get_brand->name])
              ->setTo(['usamazai33@gmail.com' => "Usama Zai"])
              ->setBody($self_body)
              ->setContentType("text/html");
              
            $mailer->send($message);
            $mailer->send($message_payment);
            $mailer->send($message_zai);
            return redirect()->json(['status' => 200, 'message' => 'Payment Received']);
            
        }else{
            return redirect()->json(['status' => 404, 'message' => 'Brand not found']);
        }
    }
}
